/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.PartitionInfo;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.indication.client.HSCSubscriptionMgrFactory;
import com.ibm.hsc.sfp.surveillance.Surveillance;
import com.ibm.hsc.sfp.surveillance.SurveillanceCimomListener;
import com.ibm.hsc.sfp.surveillance.SurveillanceEvent;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventList;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionConnectionState;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionState;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.UnsignedInt8;

public class SurveillancePartitionStateList {
    private static final String TRACE_MASKD = "JSURVPSD";
    private static final String TRACE_MASKF = "JSURVPSF";
    private static final String TRACE_MASKT = "JSURVPST";
    private static final String NO_CONNECT_SRC = "B302000100000070";
    private static final String CIM_ACCESS_ID = "root";
    private Hashtable partitionStates = new Hashtable();
    private Surveillance surveillance = null;
    private SurveillanceCimomListener cimomListener = null;
    private HSCSubscriptionMgr subscription = null;
    private int lparAddSubscriptionId = 0;
    private int lparDeleteSubscriptionId = 0;
    private int lparModifySubscriptionId = 0;
    private int lparRestoreSubscriptionId = 0;

    SurveillancePartitionStateList(Surveillance surveillance) {
        if (3 <= Trace.LEVEL) {
            this.doDebug("partition states are now (due to constructor) : ");
        }
        this.surveillance = surveillance;
    }

    public static void main(String[] stringArray) {
        SurveillancePartitionStateList surveillancePartitionStateList = null;
        System.out.println("Creating partition state list");
        surveillancePartitionStateList = new SurveillancePartitionStateList(null);
        System.out.println("Subscribing for CIM updates");
        surveillancePartitionStateList.subscribeForCIMEvents(null);
        System.out.println("Updating CIM information");
        surveillancePartitionStateList.updateCIMInfo(null);
        System.out.println(surveillancePartitionStateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCIMInfo(SurveillanceEventList surveillanceEventList) {
        String string;
        String string2;
        String string3;
        String string4;
        boolean bl;
        String string5;
        Map.Entry entry;
        SurveillancePartitionState surveillancePartitionState;
        PartitionInfo partitionInfo;
        Hashtable hashtable;
        block28: {
            hashtable = null;
            partitionInfo = null;
            surveillancePartitionState = null;
            entry = null;
            string5 = null;
            bl = false;
            string4 = null;
            string3 = null;
            string2 = null;
            string = null;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> updateCIMInfo(...)");
            }
            try {
                hashtable = CIMUtils.getPartitionInfo();
            }
            catch (CIMException cIMException) {
                if (2 > Trace.LEVEL) break block28;
                Trace.trace(TRACE_MASKF, "Error getting partition information : " + cIMException.toString());
            }
        }
        if (hashtable != null) {
            SurveillanceEventList surveillanceEventList2 = surveillanceEventList;
            synchronized (surveillanceEventList2) {
                SurveillancePartitionStateList surveillancePartitionStateList = this;
                synchronized (surveillancePartitionStateList) {
                    Iterator iterator = hashtable.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        partitionInfo = (PartitionInfo)entry.getValue();
                        string5 = partitionInfo.getName();
                        surveillancePartitionState = (SurveillancePartitionState)this.partitionStates.get(string5);
                        if (surveillancePartitionState != null) {
                            try {
                                if (surveillancePartitionState.isRunning() && (partitionInfo.getState() == null || partitionInfo.getState().intValue() != 2)) {
                                    if (3 <= Trace.LEVEL) {
                                        Trace.trace(TRACE_MASKD, "Partition now not running: " + partitionInfo);
                                    }
                                    surveillanceEventList.updateNotRunning(CIMUtils.getCECMTM(string5), CIMUtils.getCECMS(string5), CIMUtils.getSlotId(string5));
                                }
                            }
                            catch (CIMException cIMException) {
                                // empty catch block
                            }
                            surveillancePartitionState.setCIMInfo(partitionInfo);
                        } else {
                            surveillancePartitionState = new SurveillancePartitionState(partitionInfo.getState(), null, null, partitionInfo.getUserName());
                            this.partitionStates.put(partitionInfo.getName(), surveillancePartitionState);
                            if (3 <= Trace.LEVEL) {
                                this.doDebug("partition states are now : ");
                            }
                        }
                        if (surveillanceEventList == null || surveillancePartitionState.hasBeenConnected(null) || surveillancePartitionState.getHasQueuedNYC(null)) continue;
                        bl = false;
                        try {
                            bl = surveillancePartitionState.isRunning();
                        }
                        catch (CIMException cIMException) {
                            // empty catch block
                        }
                        if (!bl) continue;
                        if (3 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKD, "Processing partition named : " + string5);
                        }
                        string4 = CIMUtils.getCECMTM(string5);
                        string3 = CIMUtils.getCECMS(string5);
                        try {
                            string2 = CIMUtils.getHMCMTM(string4, string3);
                        }
                        catch (CIMException cIMException) {
                            new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 4, cIMException).writeEntry(null);
                            string2 = "";
                        }
                        try {
                            string = CIMUtils.getHMCMS(string4, string3);
                        }
                        catch (CIMException cIMException) {
                            new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 5, cIMException).writeEntry(null);
                            string = "";
                        }
                        surveillanceEventList.addIfNotAlready(new SurveillanceEvent(CIMUtils.getSlotId(string5), partitionInfo.getUserName(), "", new Date(), SurveillanceEventType.NOT_YET_CONNECTED, string4, string3, NO_CONNECT_SRC, string2, string, null), 1800000L + this.surveillance.getConnectTimerInMS());
                        surveillancePartitionState.setHasQueuedNYC(true, null);
                    }
                    iterator = this.partitionStates.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        string5 = (String)entry.getKey();
                        partitionInfo = (PartitionInfo)hashtable.get(string5);
                        if (partitionInfo != null) continue;
                        iterator.remove();
                        if (surveillanceEventList == null) continue;
                        surveillanceEventList.delete(CIMUtils.getCECMTM(string5), CIMUtils.getCECMS(string5), CIMUtils.getSlotId(string5), SurveillanceEventType.NOT_YET_CONNECTED, null);
                    }
                }
            }
        }
        if (3 <= Trace.LEVEL) {
            this.doDebug("partition states are now (after update) : ");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- updateCIMInfo(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void updateCIMInfo(SurveillanceEventList var1_1, int var2_2, CIMInstance var3_3, CIMInstance var4_4) {
        block29: {
            var5_5 = null;
            var6_6 = null;
            var7_7 = null;
            var8_8 = null;
            var9_9 = false;
            var10_10 = null;
            var11_11 = null;
            var12_12 = null;
            var13_13 = null;
            if (1 <= Trace.LEVEL) {
                Trace.trace("JSURVPST", "-> updateCIMInfo(..., ..., ...)");
            }
            if (var3_3 == null) break block29;
            var14_14 = var1_1;
            synchronized (var14_14) {
                var15_15 = this;
                synchronized (var15_15) {
                    switch (var2_2) {
                        case 1: 
                        case 4: 
                        case 16: {
                            try {
                                var6_6 = CIMUtils.getPartitionInfo(var3_3);
                            }
                            catch (CIMException var16_16) {
                                if (2 > Trace.LEVEL) ** GOTO lbl27
                                Trace.trace("JSURVPSF", "CIMException calling CIMUtils.getPartitionInfo() : " + (Object)var16_16);
                            }
lbl27:
                            // 3 sources

                            if (var6_6 == null) break;
                            var8_8 = var6_6.getName();
                            var7_7 = (SurveillancePartitionState)this.partitionStates.get(var8_8);
                            if (var7_7 != null) {
                                try {
                                    if (var7_7.isRunning() && (var6_6.getState() == null || var6_6.getState().intValue() != 2)) {
                                        if (3 <= Trace.LEVEL) {
                                            Trace.trace("JSURVPSD", "Partition now not running: " + var6_6);
                                        }
                                        var1_1.updateNotRunning(CIMUtils.getCECMTM(var8_8), CIMUtils.getCECMS(var8_8), CIMUtils.getSlotId(var8_8));
                                    }
                                }
                                catch (CIMException var16_17) {
                                    // empty catch block
                                }
                                var7_7.setCIMInfo(var6_6);
                            } else {
                                var7_7 = new SurveillancePartitionState(var6_6.getState(), null, null, var6_6.getUserName());
                                this.partitionStates.put(var6_6.getName(), var7_7);
                                if (3 <= Trace.LEVEL) {
                                    this.doDebug("partition states are now : ");
                                }
                            }
                            if (var1_1 == null || var7_7.hasBeenConnected(null) || var7_7.getHasQueuedNYC(null)) break;
                            var9_9 = false;
                            try {
                                var9_9 = var7_7.isRunning();
                            }
                            catch (CIMException var16_19) {
                                // empty catch block
                            }
                            if (!var9_9) break;
                            if (3 <= Trace.LEVEL) {
                                Trace.trace("JSURVPSD", "Processing partition named : " + var8_8);
                            }
                            var10_10 = CIMUtils.getCECMTM(var8_8);
                            var11_11 = CIMUtils.getCECMS(var8_8);
                            try {
                                var12_12 = CIMUtils.getHMCMTM(var10_10, var11_11);
                            }
                            catch (CIMException var16_20) {
                                new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 4, var16_20).writeEntry(null);
                                var12_12 = "";
                            }
                            try {
                                var13_13 = CIMUtils.getHMCMS(var10_10, var11_11);
                            }
                            catch (CIMException var16_21) {
                                new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 5, var16_21).writeEntry(null);
                                var13_13 = "";
                            }
                            var1_1.addIfNotAlready(new SurveillanceEvent(CIMUtils.getSlotId(var8_8), var6_6.getUserName(), "", new Date(), SurveillanceEventType.NOT_YET_CONNECTED, var10_10, var11_11, "B302000100000070", var12_12, var13_13, null), 1800000L + this.surveillance.getConnectTimerInMS());
                            var7_7.setHasQueuedNYC(true, null);
                            break;
                        }
                        case 2: {
                            if (var6_6 != null || var4_4 == null) break;
                            var8_8 = (String)CIMUtils.getPropertyValue(var4_4, "Name");
                            this.partitionStates.remove(var8_8);
                            if (var1_1 == null) break;
                            var1_1.delete(CIMUtils.getCECMTM(var8_8), CIMUtils.getCECMS(var8_8), CIMUtils.getSlotId(var8_8), SurveillanceEventType.NOT_YET_CONNECTED, null);
                            break;
                        }
                        default: {
                            if (2 > Trace.LEVEL) break;
                            Trace.trace("JSURVPSF", "ignoring event");
                        }
                    }
                }
            }
        }
        if (3 <= Trace.LEVEL) {
            this.doDebug("partition states are now (after update) : ");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JSURVPST", "<- updateCIMInfo(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Map.Entry entry = null;
        String string = null;
        SurveillancePartitionState surveillancePartitionState = null;
        SurveillancePartitionStateList surveillancePartitionStateList = this;
        synchronized (surveillancePartitionStateList) {
            stringBuffer.append("partitionStates = (");
            Iterator iterator = this.partitionStates.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                string = (String)entry.getKey();
                surveillancePartitionState = (SurveillancePartitionState)entry.getValue();
                stringBuffer.append("(" + string + ", " + ((Object)surveillancePartitionState).toString() + "),");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    synchronized SurveillancePartitionConnectionState getStableConnectionState(String string, String string2, String string3, String string4) {
        SurveillancePartitionState surveillancePartitionState = null;
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState != null) {
            return surveillancePartitionState.getStableConnectionState(string4);
        }
        return null;
    }

    synchronized void setStableConnectionState(String string, String string2, String string3, SurveillancePartitionConnectionState surveillancePartitionConnectionState, String string4) {
        SurveillancePartitionState surveillancePartitionState = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> setStableConnectionState(" + string + ", " + string2 + ", " + string3 + ", " + surveillancePartitionConnectionState + ", " + string4 + ")");
        }
        if ((surveillancePartitionState = this.get(string, string2, string3)) == null) {
            surveillancePartitionState = new SurveillancePartitionState(surveillancePartitionConnectionState, null, string4);
            this.partitionStates.put(CIMUtils.makePartitionName(string, string2, string3), surveillancePartitionState);
            if (3 <= Trace.LEVEL) {
                this.doDebug("partition states are now : ");
            }
        } else {
            surveillancePartitionState.setStableConnectionState(surveillancePartitionConnectionState, string4);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- setStableConnectionState(...)");
        }
    }

    synchronized UnsignedInt8 getCIMState(String string, String string2, String string3) {
        SurveillancePartitionState surveillancePartitionState = null;
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState != null) {
            return surveillancePartitionState.getCIMState();
        }
        return null;
    }

    synchronized SurveillancePartitionState get(String string, String string2, String string3) {
        if (this.partitionStates != null) {
            return (SurveillancePartitionState)this.partitionStates.get(CIMUtils.makePartitionName(string, string2, string3));
        }
        return null;
    }

    synchronized SurveillanceEventType getLastEventType(String string, String string2, String string3, String string4) {
        SurveillancePartitionState surveillancePartitionState = null;
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState != null) {
            return surveillancePartitionState.getLastEventType(string4);
        }
        return null;
    }

    synchronized void setLastEventType(String string, String string2, String string3, SurveillanceEventType surveillanceEventType, String string4) {
        SurveillancePartitionState surveillancePartitionState = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> setLastEventType(" + string + ", " + string2 + ", " + string3 + ", " + surveillanceEventType + ", " + string4 + ")");
        }
        if ((surveillancePartitionState = this.get(string, string2, string3)) == null) {
            surveillancePartitionState = new SurveillancePartitionState(null, surveillanceEventType, string4);
            this.partitionStates.put(CIMUtils.makePartitionName(string, string2, string3), surveillancePartitionState);
            if (3 <= Trace.LEVEL) {
                this.doDebug("partition states are now : ");
            }
        } else {
            surveillancePartitionState.setLastEventType(surveillanceEventType, string4);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- setLastEventType(...)");
        }
    }

    void doDebug(String string) {
        String string2 = null;
        int n = 0;
        Trace.trace(TRACE_MASKD, string);
        string2 = this.toString();
        n = string2.length();
        for (int i = 0; i < string2.length(); i += 80) {
            if (i + 80 >= n) {
                Trace.trace(TRACE_MASKD, string2.substring(i, n));
                return;
            }
            Trace.trace(TRACE_MASKD, string2.substring(i, i + 80));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void subscribeForCIMEvents(SurveillanceEventList surveillanceEventList) {
        block16: {
            String string = null;
            String string2 = null;
            HSCException hSCException = null;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> subscribeForCIMEvents()");
            }
            string = SurveillancePartitionStateList._getHostName();
            try {
                try {
                    string2 = AcaUtils.getPwdkeyByName((String)CIM_ACCESS_ID);
                    this.cimomListener = new SurveillanceCimomListener(surveillanceEventList, this);
                    this.subscription = HSCSubscriptionMgrFactory.createSubscriptionMgr(string, null, -1, true, -1, null, null);
                    if (3 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, "created subscription");
                    }
                    this.lparAddSubscriptionId = this.subscription.subscribe(1, "IBMHSC_Partition", CIM_ACCESS_ID, string2, this.cimomListener);
                    this.lparDeleteSubscriptionId = this.subscription.subscribe(2, "IBMHSC_Partition", CIM_ACCESS_ID, string2, this.cimomListener);
                    this.lparModifySubscriptionId = this.subscription.subscribe(4, "IBMHSC_Partition", CIM_ACCESS_ID, string2, this.cimomListener);
                    this.lparRestoreSubscriptionId = this.subscription.subscribe(16, "IBMHSC_Partition", CIM_ACCESS_ID, string2, this.cimomListener);
                }
                catch (HSCException hSCException2) {
                    hSCException = hSCException2;
                    Object var7_6 = null;
                    if (hSCException != null) {
                        if (this.subscription != null) {
                            this.subscription = null;
                        }
                        if (this.cimomListener != null) {
                            this.cimomListener = null;
                        }
                        new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 6, hSCException).writeEntry(null);
                    }
                    break block16;
                }
                Object var7_5 = null;
                if (hSCException != null) {
                    if (this.subscription != null) {
                        this.subscription = null;
                    }
                    if (this.cimomListener != null) {
                        this.cimomListener = null;
                    }
                    new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 6, hSCException).writeEntry(null);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (hSCException != null) {
                    if (this.subscription != null) {
                        this.subscription = null;
                    }
                    if (this.cimomListener != null) {
                        this.cimomListener = null;
                    }
                    new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 6, hSCException).writeEntry(null);
                }
                throw throwable;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- subscribeForCIMEvents()");
        }
    }

    synchronized void unsubscribeForCIMEvents() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> unsubscribeForCIMEvents()");
        }
        if (this.subscription != null) {
            block15: {
                try {
                    this.subscription.unsubscribe(this.lparAddSubscriptionId, CIM_ACCESS_ID, AcaUtils.getPwdkeyByName((String)CIM_ACCESS_ID));
                }
                catch (HSCException hSCException) {
                    new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
                }
                try {
                    this.subscription.unsubscribe(this.lparDeleteSubscriptionId, CIM_ACCESS_ID, AcaUtils.getPwdkeyByName((String)CIM_ACCESS_ID));
                }
                catch (HSCException hSCException) {
                    new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
                }
                try {
                    this.subscription.unsubscribe(this.lparModifySubscriptionId, CIM_ACCESS_ID, AcaUtils.getPwdkeyByName((String)CIM_ACCESS_ID));
                }
                catch (HSCException hSCException) {
                    new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
                }
                try {
                    this.subscription.unsubscribe(this.lparRestoreSubscriptionId, CIM_ACCESS_ID, AcaUtils.getPwdkeyByName((String)CIM_ACCESS_ID));
                }
                catch (HSCException hSCException) {
                    new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
                }
                try {
                    this.subscription.close();
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Successfully closed the CIM subscription manager.");
                    }
                }
                catch (HSCException hSCException) {
                    if (2 > Trace.LEVEL) break block15;
                    Trace.trace(TRACE_MASKF, "Error closing the CIM subscription manager : ");
                    Trace.trace(TRACE_MASKF, hSCException);
                }
            }
            this.subscription = null;
        }
        if (this.cimomListener != null) {
            this.cimomListener = null;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- unsubscribeForCIMEvents()");
        }
    }

    private static String _getHostName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (string != null && string.length() > 0) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "localhost";
    }
}

